/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen.animator.dialog;

import java.util.function.Consumer;
import java.util.regex.Pattern;
import lib.toma.animations.api.event.IAnimationEvent;
import lib.toma.animations.engine.screen.animator.AnimatorScreen;
import lib.toma.animations.engine.screen.animator.dialog.DialogScreen;
import lib.toma.animations.engine.screen.animator.dialog.SuggestionResponder;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class EditEventDialog
extends DialogScreen {
    private final IAnimationEvent clickedEvent;
    private final IPositionChanger positionChanger;
    private TextFieldWidget position;
    private final Pattern posPattern = Pattern.compile("(1(\\.0)?)|(0(\\.[0-9]+)?)");
    private boolean valid;

    public EditEventDialog(AnimatorScreen screen, IAnimationEvent clickedEvent, IPositionChanger positionChanger) {
        super((ITextComponent)new TranslationTextComponent("screen.animator.dialog.edit_event"), screen);
        this.clickedEvent = clickedEvent;
        this.positionChanger = positionChanger;
        this.setDimensions(180, 65);
    }

    @Override
    public boolean func_231177_au__() {
        return true;
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        int btnWidthFull = this.dWidth() - 10;
        int btnWidthPartial = (this.dWidth() - 20) / 3;
        this.position = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.left() + 5, this.top() + 15, btnWidthFull, 20, StringTextComponent.field_240750_d_));
        this.position.func_212954_a((Consumer)new SuggestionResponder("Position", this.position, this::position_changed));
        this.position.func_146180_a(AnimatorScreen.POSITION_FORMAT.format(this.clickedEvent.invokeAt()));
        this.cancel = (Button)this.func_230480_a_((Widget)new Button(this.left() + 5, this.top() + 40, btnWidthPartial, 20, CANCEL, this::cancel_clicked));
        this.func_230480_a_((Widget)new Button(this.left() + 10 + btnWidthPartial, this.top() + 40, btnWidthPartial, 20, (ITextComponent)new StringTextComponent("Delete"), this::delete_clicked));
        this.confirm = (Button)this.func_230480_a_((Widget)new Button(this.left() + this.dWidth() - 5 - btnWidthPartial, this.top() + 40, btnWidthPartial, 20, CONFIRM, this::confirm_clicked));
        this.updateConfirmButton();
    }

    private void position_changed(String value) {
        if (this.posPattern.matcher(value).matches()) {
            this.position.func_146193_g(0xE0E0E0);
            this.valid = true;
        } else {
            this.position.func_146193_g(0xE00000);
            this.valid = false;
        }
        this.updateConfirmButton();
    }

    private void confirm_clicked(Button button) {
        this.positionChanger.change(this.clickedEvent, this.clickedEvent.copyAt(Float.parseFloat(this.position.func_146179_b())));
        this.showParent();
    }

    private void delete_clicked(Button button) {
        this.positionChanger.change(this.clickedEvent, null);
        this.showParent();
    }

    private void updateConfirmButton() {
        if (this.confirm != null) {
            this.confirm.field_230693_o_ = this.valid;
        }
    }

    public static interface IPositionChanger {
        public void change(IAnimationEvent var1, IAnimationEvent var2);
    }
}

